/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.perks;

import dev.toma.gunsrpg.resource.perks.CrystalConfiguration;
import dev.toma.gunsrpg.resource.perks.FusionConfiguration;
import dev.toma.gunsrpg.resource.perks.PurificationConfiguration;
import net.minecraft.network.PacketBuffer;

public final class PerkConfiguration {
    private final CrystalConfiguration crystals;
    private final FusionConfiguration fusion;
    private final PurificationConfiguration purification;

    public PerkConfiguration(CrystalConfiguration crystals, FusionConfiguration fusion, PurificationConfiguration purification) {
        this.crystals = crystals;
        this.fusion = fusion;
        this.purification = purification;
    }

    public CrystalConfiguration getCrystalConfig() {
        return this.crystals;
    }

    public FusionConfiguration getFusionConfig() {
        return this.fusion;
    }

    public PurificationConfiguration getPurificationConfig() {
        return this.purification;
    }

    public void encode(PacketBuffer buffer) {
        this.crystals.encode(buffer);
        this.fusion.encode(buffer);
        this.purification.encode(buffer);
    }

    public static PerkConfiguration decode(PacketBuffer buffer) {
        return new PerkConfiguration(CrystalConfiguration.decode(buffer), FusionConfiguration.decode(buffer), PurificationConfiguration.decode(buffer));
    }
}

